//
//  YHAppointWarmTipsCell.swift
//  galaxy
//
//  Created by edy on 2024/8/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAppointWarmTipsCell: UITableViewCell {

    static let cellReuseIdentifier = "YHAppointWarmTipsCell"

    var bgImgView: UIImageView = {
        let imgView = UIImageView(image: UIImage(named: "appoint_warm_tips"))
        return imgView
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        
        contentView.addSubview(bgImgView)
        bgImgView.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.bottom.equalTo(0)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(bgImgView.snp.width).multipliedBy(184.0/343.0)
        }
    }

}
